function sys_state = Decoupling_closed_sys_performance(t,xx,A,B,F,D1,C,D2,P,N,J,L,H,Q)
Z = xx(1:3);
veq = xx(4);
hat_rho = xx(5);
X = xx(6:7);
hat_rho1 = xx(8);
hat_rho2 = xx(9);

global Intd_u Intd_yy2 Intd_ts Intd_count Intd_tmp Intd_hatfa  Intd_ffa Intd_hatd Intd_uu


bar_C = [C D2]; 
W = inv(P)*bar_C'*Q;

% parameters
tau = 1.0e-3; 
sigma0 = 5; 
sigma1 = 0.1; 
sigma2 = 0.1; 
epsilon = 1.0e0; 
epsilon1 = 1.0e-1; 
epsilon2 = 1.0e-1;

d = 2*sin(2*pi*t); % disturbance
fa = f(t); % fault
xd = 1; % output tracking reference

%estimated state and fault
X = X - [xd; 0];
bar_x = [X;d];
y = bar_C*bar_x  + [1;1]*noise(t); 
hat_x = Z + H*y;
bar_y = bar_C*hat_x;
ey = y - bar_y;

rho_v = hat_rho + epsilon;
v = rho_v*Q'*ey/(norm(Q'*ey,2)+1.0e-3);
hat_f = veq;

% controller
A1 = A(1,1);  B1 = A(1,2); S1 = D1(1)/B1;
A2 = A(2,:); B2 = B(2); S2 = D1(2)/B2;

c1 = 35; c2 = 60;

z1 = hat_x(1); 
rho1 = hat_rho1 + epsilon1;
alpha1 = -pinv(B1)*((c1+rho1)*z1 + A1*hat_x(1)) - S1*hat_x(3);

z2 = hat_x(2) - alpha1;
rho2 = hat_rho2 + epsilon2;
uu = Intd_uu;
dot_z1 = A(1,:)*X + B(1,:)*uu + F(1,:)*fa + D1(1,:)*d;

dot_d = 0;
dot_Z1 = N(1,:)*Z + J(1,:)*uu + L(1,:)*y + W(1,:)*v;
dot_y1 = H(1,:)*bar_C*[A*X + B*uu + F*fa + D1*d; dot_d ];
dot_Z3 = N(3,:)*Z + J(3,:)*uu + L(3,:)*y + W(3,:)*v;
dot_y3 = H(3,:)*bar_C*[A*X + B*uu + F*fa + D1*d; dot_d ];

dot_alpha1 = -pinv(B1)*(c1*dot_z1 + A1*( dot_Z1 + dot_y1) ) - S1*(dot_Z3 + dot_y3);
u = -pinv(B2) * ((c2+ rho2)*z2 + A2*X + B1'*z1 - dot_alpha1) - hat_f - S2*hat_x(3);
Intd_uu = u;

dot_hat_rho1 = sigma1*norm(z1,2)^2;
dot_hat_rho2 = sigma2*norm(z2,2)^2;

%observer
dot_Z = N*Z + J*u + L*y + W*v;
dot_veq = 1/tau *(-veq + v);
dot_rho = sigma0*norm(Q'*ey,2);


% sys dynamic
dot_X = A*X + B*u + F*fa + D1*d;
y0 = y - D2*hat_x(3);

% data saving 
if mod(Intd_tmp,12)==0
    Intd_count = Intd_count + 1;
Intd_ts(Intd_count) = t;
Intd_ffa(Intd_count) = fa;
Intd_u(Intd_count) = u;
Intd_yy2(Intd_count) = y0(2);
Intd_hatfa(Intd_count) = fa - hat_f;
Intd_hatd(Intd_count) = d - hat_x(3);
end
Intd_tmp = Intd_tmp + 1;

sys_state = [dot_Z;dot_veq;dot_rho;dot_X; dot_hat_rho1; dot_hat_rho2];